CREATE TABLE {{cookiecutter.project_name}}.users (
    uid BIGINT PRIMARY KEY,
    login TEXT
);

create type {{cookiecutter.project_name}}.task_type as enum ('run_action');
create type {{cookiecutter.project_name}}.task_state as enum ('failed', 'pending', 'processing', 'finished', 'deleted', 'cleanup');
create type {{cookiecutter.project_name}}.worker_type as enum ('run_action');
create type {{cookiecutter.project_name}}.worker_state as enum ('running', 'shutdown', 'failed', 'cleanedup');


create table {{cookiecutter.project_name}}.tasks (
    task_id     bigserial   primary key,
    task_type   {{cookiecutter.project_name}}.task_type   not null,
    state       {{cookiecutter.project_name}}.task_state  not null,
    params      jsonb,
    details     jsonb,
    retries     integer                   not null default 0,
    run_at      timestamptz               not null default now(),
    created     timestamptz               not null default now(),
    updated     timestamptz               not null default now(),
    action_name text
);

create table {{cookiecutter.project_name}}.workers (
    worker_id   text        primary key,
    worker_type {{cookiecutter.project_name}}.worker_type  not null,
    host        text                       not null,
    state       {{cookiecutter.project_name}}.worker_state not null,
    heartbeat   timestamptz,
    startup     timestamptz,
    task_id     bigint                     references {{cookiecutter.project_name}}.tasks
);

create index tasks_state_run_at_idx on {{cookiecutter.project_name}}.tasks (state, run_at);
